
package gov.va.med.mhv.sm.api.enumeration;

import java.util.Arrays;
import java.util.List;

public enum SMApiErrorTransEnum {
	UNKNOWN_00 (00,"Translation Not Found"),
//	UNKNOWN_99 (99,"Unknown application error  Re-TransLated");
	END_DATE_CANNOT_PRECEED_START_DATE (98, "The From Date must precede the To Date."),
	BODY_CANT_BE_NULL_100 (100, "The message body cannot be blank."),
	TRIAGE_TEAM_NOT_FOUND_119 (119, "You can no longer send messages to this Secure Messaging Triage Group. Please contact the My HealtheVet Coordinator at your local VA Medical Center to see if this Triage Group is currently participating in Secure Messaging, and if you are enrolled in the Triage Group."),
	UNABLE_TO_REPLY_NOT_ASSOCIATED_TRIAGE_TEAM_129 (129, "You can no longer send messages to this Secure Messaging Triage Group.  Please contact the My HealtheVet Coordinator at your local VA Medical Center to see if this Triage Group is currently participating in Secure Messaging, and if you are enrolled in the Triage Group."),
	UNABLE_TO_REPLY_EXPIRED_MESSAGE_130 (130, "This message has expired.  Please create a new message to continue."),
	USER_BLOCKED_FACILITY_151 (151, "Your access to this Triage Group has been restricted.  You cannot send messages to this Triage Group.  If you think your access was restricted by mistake, contact your My HealtheVet Coordinator at your local VA Medical Center."),
	FOLDER_REQUIRES_NAME_125 (125, "Folder name should not be blank."),
	FOLDER_ALREADY_EXISTS_126 (126, "You already have the same folder name. Please enter different folder name."),
	FOLDER_REQUIRES_ALPHANUMERIC_NAME_127 (127, "Folder name should only contain letters, numbers, and spaces."),
	INVALID_EMAIL_ADDRESS_152 (152, "Enter a valid email address, e.g.name@email.com."),
	EMAIL_SIGNATURE_NAME_TITLE_REQUIRED (154, "Please enter Name and Title."),
	NO_MESSAGES_SELECTED (907, "No messages were selected to move or delete."),
	NO_FOLDER_SELECTED(910,"Select a folder to move the message(s)."),
	NO_FOLDER_SELECTED_VIEW_MESSAGE (911, "Select a folder to move the message."),
	EMAIL_ADDRESS_BLANK (908, "Email Address cannot be blank."),
	SELECT_EMAIL_FREQUENCY (909, "Please select frequency.");


	
	private int id;
	private String errorMessage;
	private Class<?> clazz;
	
	private SMApiErrorTransEnum() {
	}
	
	private SMApiErrorTransEnum(int id, String errorMessage){
		this.id = id;
		this.errorMessage = errorMessage;
		this.clazz = null;
	}
	private SMApiErrorTransEnum(int id, String errorMessage, Class<?> clazz){
		this.id = id;
		this.errorMessage = errorMessage;
		this.clazz = clazz;
	}
	public int getId() {
		return id;
	}
	public void setId(int id) {
		this.id = id;
	}
	public String getErrorMessage() {
		return errorMessage;
	}
	public void setErrorMessage(String errorMessage) {
		this.errorMessage = errorMessage;
	}
	public Class<?> getClazz() {
		return clazz;
	}
	public void setClazz(Class<?> clazz) {
		this.clazz = clazz;
	}
	
	public static SMApiErrorTransEnum valueOf(int id) {
		for(SMApiErrorTransEnum f : SMApiErrorTransEnum.values()){
			if(f.getId()==(id))
				return f;
		}
		return SMApiErrorTransEnum.UNKNOWN_00;
	}
	
	public static List<ErrorEnum> toList(){
		return Arrays.asList(ErrorEnum.values());
	}
}
